%Continuous Doppler signal simulation
% 21.09.02  Hans Torp
c=1540;%speed of sound
fs=20e6;%sampling freq.
T=0.001;
t=0:1/fs:T;%time axis
f0=2e6;%transmitted frequency

stx=cos(2*pi*f0*t);%transmitted signal


v=2;%m/sec
z=-v*t;%positive velocity towards transducer
tau=2*z/c;%echo delay
att=0.25e-4;%attenuation factor
srx=att*cos(2*pi*f0*(t-tau));%received signal from reflector

cross=1e-4;%crosstalk from tx to rx transducer

s=cross*stx+srx;%total signal received
figure(1);clf;
subplot(3,1,1);plot(t,s);zoom xon;ylabel('RF signal');

pause;
% amplitude demodulation
sd=abs(s);
[b,a]=butter(4,0.5*f0/fs);%low pass filter
sd=filter(b,a,sd);
%sd=sd-mean(sd);%remove DC component
subplot(3,1,2);plot(t,sd);zoom xon;ylabel('Amplitude');

pause;
%complex demodulation
iq=hilbert(s).*exp(-i*2*pi*f0*t);
iq=iq-mean(iq);%remove DC from crosstalk

subplot(3,1,3);plot(t,real(iq),t,imag(iq));legend('I','Q');ylabel('Compl.Ampl.');
zoom xon;


