%Autocorrelation function estimator -statistical properties
%Script to investigate distribution of complex autocorrelation function estimate
% and estimators for power, mean frequency and bandwidth
%Uses Csignaldemo.m
%06.08.02  Hans Torp
P=1;
w1=1;
B=0.5;
Nsamples=200;
z=Csignaldemo(P,w1,B,Nsamples);
z1=z(1:end-1);
z2=z(2:end);
R0=conj(z1).*z1;
R1=conj(z1).*z2;
Naverage=6;
b=ones(Naverage,1)/Naverage;%averaging filter coefficients
R0=filter(b,1,R0);
R1=filter(b,1,R1);
Pest=R0;
w1est=angle(R1);
ro=R1./R0;
Best=sqrt(2*abs((1-abs(ro))));
maxR1=max(abs(R1));
figure(1);
subplot(2,1,1);plot(R1,'.');
axis('image');axis(maxR1*[-1,1,-1,1]);grid;
xlabel('real(R1)');ylabel('imag(R1)');
subplot(2,1,2);
plot(abs(R1),angle(R1),'.');grid;
xlabel('abs(R1)');ylabel('angle(R1)');
pause;
figure(2);
subplot(3,1,1);hist(Pest,0:0.1:5*P);xlabel('Power estimate');
subplot(3,1,2);hist(w1est,-pi:0.05:pi);xlabel('Mean freq. estimate');
subplot(3,1,3);hist(Best,0:0.1:2);xlabel('Bandwidth estimate');
biasw1=mean(w1est)-w1
stdw1=std(w1est)
