%Autocorrelation function estimator - effect of spatio/temporal averaging
%Script to investigate distribution of the complex autocorrelation function estimate
% and estimators for power, mean frequency and bandwidth
% effect of averaging between uncorrelated datasegments
%Uses Csignaldemo.m
%06.08.02  Hans Torp
clear;
P=1;
w1=0;
B=0.1;
N=6;%packet size
Nsamples=4000;
M=4;%Averaging number
for m=1:M,
    z=Csignaldemo(P,w1,B,Nsamples);%signal
    zn=Csignaldemo(P/10,0,10,Nsamples);%white noise
    z=z+zn;
    z1=z(1:end-1);
    z2=z(2:end);
    b=ones(N,1)/N;%averaging filter coefficients
    R0(:,m)=filter(b,1,conj(z1).*z1);
    R1(:,m)=filter(b,1,conj(z1).*z2);
end;
w1est=angle(R1(:,1));
w1mean1=mean(angle(R1),2);
w1mean2=angle(mean(R1,2));
stdw1=std(w1est)
stdw1mean1=std(w1mean1)
stdw1mean2=std(w1mean2)

figure(2); 
subplot(2,1,1);plot(R1(:),'b.');axis('equal');grid;
hold on;plot(mean(R1,2),'r.');hold off;
xlabel('R1 real part'):ylabel('R1 imag. part');
legend('R1','mean(R1)');
subplot(2,1,2);
hist([w1est,w1mean2],-pi:0.02:pi);
xlabel('phase angle [rad]');
legend('angle(R1)','angle(mean(R1))');
axis('tight');
